const express = require("express");
const paymentController = require("../controllers/paymentController");
const authController = require("../controllers/authController");

const router = express.Router();

// 1. Initiate Payment (User must be logged in)
// POST /api/payment/initiate
router.post(
  "/initiate",
  authController.protect, // Login Required
  paymentController.initiatePayment
);

// 2. Webhook (Public route for Paymob Server)
// POST /api/payment/webhook
// ⚠️ No authController.protect here! Paymob doesn't have a token.
router.post("/webhook", paymentController.paymobWebhook);

module.exports = router;
